Option Strict Off
Option Explicit On
Friend Class Form1
	Inherits System.Windows.Forms.Form

	'GDevlib_GT27 Declaration
    Private Declare Function GDev_Read Lib "GDevlib_GT27.dll" (ByVal ulMapPointer As Integer, ByVal sDevNameID As Short, ByVal lDevNum As Integer, ByVal lpsDataTable As IntPtr, ByVal lDataSize As Integer) As Integer
    Private Declare Function GDev_Write Lib "GDevlib_GT27.dll" (ByVal ulMapPointer As Integer, ByVal sDeviceNameID As Short, ByVal lDevNum As Integer, ByVal lpsDataTable As IntPtr, ByVal lDataSize As Integer) As Integer
    Private Declare Function GDev_OpenMapping Lib "GDevlib_GT27.dll" (ByRef lphMapFile As Integer, ByVal sGotNo As Short) As Integer
    Private Declare Sub GDev_CloseUnMapping Lib "GDevlib_GT27.dll" (ByVal hMapFile As Integer, ByVal lMapPointer As Integer)

    Private Declare Function GDev_Read64 Lib "GDevlib64_GT27.dll" Alias "GDev_Read" (ByVal ulMapPointer As UInt64, ByVal sDevNameID As Short, ByVal lDevNum As Int32, ByVal lpsDataTable As IntPtr, ByVal lDataSize As Int32) As Int32
    Private Declare Function GDev_Write64 Lib "GDevlib64_GT27.dll" Alias "GDev_Write" (ByVal ulMapPointer As UInt64, ByVal sDeviceNameID As Short, ByVal lDevNum As Int32, ByVal lpsDataTable As IntPtr, ByVal lDataSize As Int32) As Int32
    Private Declare Function GDev_OpenMapping64 Lib "GDevlib64_GT27.dll" Alias "GDev_OpenMapping" (ByRef lphMapFile As IntPtr, ByVal sGotNo As Short) As UInt64
    Private Declare Sub GDev_CloseUnMapping64 Lib "GDevlib64_GT27.dll" Alias "GDev_CloseUnMapping" (ByVal hMapFile As IntPtr, ByVal lMapPointer As UInt64)

    Private Const GDEV_GB_ID As Short = 0
    Private Const GDEV_GD_ID As Short = 1
    Private Const GDEV_GS_ID As Short = 2

    Private Const GDEV_OK As Short = 0
    Private Const GDEV_ERR_DEV_NAME_ID As Short = -1
    Private Const GDEV_ERR_DEV_NUM_MIN As Short = -2
    Private Const GDEV_ERR_DEV_NUM_MAX As Short = -3
    Private Const GDEV_ERR_MAP_POINTER As Short = -9

    'Form1 Declaration
    Private Const SWNO_SOFTGOT As Short = 1
    Private Const GBGD_NUM_MAX As Integer = 65535
    Private Const GS_NUM_MAX As Short = 2047
    Private Const INT_VALUE_MAX As Short = 32767
    Private Const INT_VALUE_MIN As Short = -32768
    Private Const FORCED As Short = 1

    Dim lMapFile As Integer = 0
    Dim lMapPointer As Integer = 0
    Dim lMapPointer64 As UInt64 = 0
    Dim lMaskTable(15) As UInt32

    Private Sub Form1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim iLoop As Short

        lMaskTable(0) = &H1
        For iLoop = 0 To 14
            lMaskTable(iLoop + 1) = lMaskTable(iLoop) * &H2
        Next

    End Sub

    Private Sub Form1_FormClosing(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim Cancel As Boolean = eventArgs.Cancel
        Dim UnloadMode As System.Windows.Forms.CloseReason = eventArgs.CloseReason

        Dim bRet As Boolean

        If UnloadMode = System.Windows.Forms.CloseReason.UserClosing Then
            bRet = Termination()
            If bRet = False Then
                Cancel = True
            End If
        End If

        eventArgs.Cancel = Cancel
    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// Dialog Close.

    Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click

        Dim bRet As Boolean

        bRet = Termination
        If bRet = False Then
            Exit Sub
        End If

        End

    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// Monior Start.

    Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click

        Dim bRet As Boolean

        If Command2.Text = "&Start monitor" Then
            If MsgBox("The monitor is about to be started." & vbLf & "Is it OK?", MsgBoxStyle.OkCancel + MsgBoxStyle.Exclamation) = 1 Then
                If Not GDevOpen() Then
                    Call MsgBox("GT SoftGOT2000 has not been started." & vbLf & "(Cannot access the internal device)", MsgBoxStyle.OkOnly + MsgBoxStyle.Critical)
                    Exit Sub
                End If

                Label15.Text = "*"
                Command2.Text = "&Stop monitor"

                Timer1.Enabled = True
            End If

        Else
            bRet = Termination()
        End If

    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// GB Device Write. (ON:Index = 0, OFF:Index = 1)

    Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
        Dim Index As Short = Command3.GetIndex(eventSender)

        Dim iDataTable(255) As Short
        Dim lRet As Integer
        Dim lDevNo As Integer
        Dim lInputDevNo As Integer
        Dim Shift As Short
        Dim BitMask As Short

        lDevNo = 0
        lInputDevNo = 0

        If Not IsGDevOpen() Then
            Call MsgBox("The monitor is out of operation." & vbLf & "(Start the monitor)", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation)
            Exit Sub
        End If

        lInputDevNo = Int(CDbl(NumericUpDown1.Value))
        If lInputDevNo < 0 Then
            lInputDevNo = 0
        ElseIf lInputDevNo > GBGD_NUM_MAX Then
            lInputDevNo = GBGD_NUM_MAX
        End If

        lDevNo = Fix(lInputDevNo / 16) * 16

        lRet = GDevRead(0, lDevNo, iDataTable, 1)

        Select Case lRet
            Case GDEV_OK
                BitMask = 1
                Shift = lInputDevNo Mod 16
                BitMask = BitMask << Shift

                If Index = 0 Then
                    iDataTable(0) = iDataTable(0) Or BitMask
                Else
                    BitMask = Not CShort(BitMask)
                    iDataTable(0) = iDataTable(0) And BitMask
                End If

                lRet = GDevWrite(0, lDevNo, iDataTable, 1)

                Select Case lRet
                    Case GDEV_OK
                    Case GDEV_ERR_DEV_NAME_ID
                    Case GDEV_ERR_DEV_NUM_MIN
                    Case GDEV_ERR_DEV_NUM_MAX
                    Case GDEV_ERR_MAP_POINTER
                    Case Else
                End Select

            Case GDEV_ERR_DEV_NAME_ID
            Case GDEV_ERR_DEV_NUM_MIN
            Case GDEV_ERR_DEV_NUM_MAX
            Case GDEV_ERR_MAP_POINTER
            Case Else
        End Select

    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// GD/GS Device Write. (GD:Index = 0, GS:Index = 1)

    Private Sub Command4_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Click
        Dim Index As Short = Command4.GetIndex(eventSender)

        Dim iDataTable(255) As Short
        Dim lRet As Integer
        Dim lDevNo As Integer
        ' Dim iLoop As Short

        iDataTable(0) = 0
        lDevNo = 0

        If Not IsGDevOpen() Then
            Call MsgBox("The monitor is out of operation." & vbLf & "(Start the monitor)", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation)
            Exit Sub
        End If

        Select Case Index
            Case 0
                lDevNo = NumericUpDown2.Value
            Case 1
                lDevNo = NumericUpDown3.Value
            Case Else
                Exit Sub
        End Select

        If IsNumeric(Text2(Index).Text) = True Then
            If Int(CDbl(Text2(Index).Text)) >= INT_VALUE_MIN And Int(CDbl(Text2(Index).Text)) <= INT_VALUE_MAX Then
                iDataTable(0) = CShort(Text2(Index).Text)

                lRet = GDevWrite(Index + 1, lDevNo, iDataTable, 1)

                Select Case lRet
                    Case GDEV_OK
                    Case GDEV_ERR_DEV_NAME_ID
                    Case GDEV_ERR_DEV_NUM_MIN
                    Case GDEV_ERR_DEV_NUM_MAX
                    Case GDEV_ERR_MAP_POINTER
                    Case Else
                End Select

            Else
                Call MsgBox("Please enter an integer between -32768 and 32767.", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation)
            End If

        Else
            Call MsgBox("Please enter an integer between -32768 and 32767.", MsgBoxStyle.OkOnly + MsgBoxStyle.Exclamation)
        End If

    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// TextBox2 Input check.

    Private Sub Text2_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles Text2.KeyPress
        Dim KeyAscii As Short = Asc(eventArgs.KeyChar)
        Dim Index As Short = Text2.GetIndex(eventSender)

        If KeyAscii >= 32 And KeyAscii < 48 Or KeyAscii > 57 Then
            If KeyAscii <> 45 Then
                KeyAscii = 0
            End If
        End If

        eventArgs.KeyChar = Chr(KeyAscii)
        If KeyAscii = 0 Then
            eventArgs.Handled = True
        End If
    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// Monitor routine.

    Private Sub Timer1_Tick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Timer1.Tick

        Dim lRet As Integer
        Dim iDataTable(255) As Short
        Dim lDevNo As Integer
        Dim lInputDevNo As Integer

        lDevNo = 0
        lInputDevNo = 0

        '// Device error check.
        If Not IsGDevOpen() Then
            Timer1.Enabled = False
            Call MsgBox("Cannot refer to the internal device." & vbLf & "The monitor is about to be terminated.", MsgBoxStyle.OkOnly + MsgBoxStyle.Critical)
            End
        End If

        '// GB Device Access.
        lInputDevNo = Int(CDbl(NumericUpDown1.Value))
        If lInputDevNo < 0 Then
            lInputDevNo = 0
        ElseIf lInputDevNo > GBGD_NUM_MAX Then
            lInputDevNo = GBGD_NUM_MAX
        End If

        lDevNo = Fix(lInputDevNo / 16) * 16

        lRet = GDevRead(GDEV_GB_ID, lDevNo, iDataTable, 1)

        Select Case lRet
            Case GDEV_OK
                If (iDataTable(0) And lMaskTable(lInputDevNo Mod 16)) <> 0 Then
                    Label1.Text = CStr(1)
                Else
                    Label1.Text = CStr(0)
                End If

            Case GDEV_ERR_DEV_NAME_ID
            Case GDEV_ERR_DEV_NUM_MIN
            Case GDEV_ERR_DEV_NUM_MAX
            Case GDEV_ERR_MAP_POINTER
            Case Else
        End Select

        '// GD Device Access.
        If CDbl(NumericUpDown2.Value) >= 0 And CDbl(NumericUpDown2.Value) <= GBGD_NUM_MAX Then
            lRet = GDevRead(GDEV_GD_ID, Int(CDbl(NumericUpDown2.Value)), iDataTable, 1)

        ElseIf CDbl(NumericUpDown2.Value) < 0 Then
            lRet = GDevRead(GDEV_GD_ID, 0, iDataTable, 1)
        Else
            lRet = GDevRead(GDEV_GD_ID, GBGD_NUM_MAX, iDataTable, 1)
        End If

        Select Case lRet
            Case GDEV_OK
                Label2.Text = CStr(iDataTable(0))

            Case GDEV_ERR_DEV_NAME_ID
            Case GDEV_ERR_DEV_NUM_MIN
            Case GDEV_ERR_DEV_NUM_MAX
            Case GDEV_ERR_MAP_POINTER
            Case Else
        End Select

        '// GS Device Access.
        If CDbl(NumericUpDown3.Value) >= 0 And CDbl(NumericUpDown3.Value) <= GS_NUM_MAX Then
            lRet = GDevRead(GDEV_GS_ID, Int(CDbl(NumericUpDown3.Value)), iDataTable, 1)
        ElseIf CDbl(NumericUpDown3.Value) < 0 Then
            lRet = GDevRead(GDEV_GS_ID, 0, iDataTable, 1)
        Else
            lRet = GDevRead(GDEV_GS_ID, GS_NUM_MAX, iDataTable, 1)
        End If

        Select Case lRet
            Case GDEV_OK
                Label3.Text = CStr(iDataTable(0))

            Case GDEV_ERR_DEV_NAME_ID
            Case GDEV_ERR_DEV_NUM_MIN
            Case GDEV_ERR_DEV_NUM_MAX
            Case GDEV_ERR_MAP_POINTER
            Case Else
        End Select

    End Sub

    '/////////////////////////////////////////////////////////////////////////////
    '// Monitor termination

    Private Function Termination() As Boolean

        Dim bRet As Boolean

        bRet = True

        If lMapFile <> 0 And IsGDevOpen() Then
            If MsgBox("The monitor is about to be discontinued." & vbLf & "Is it OK to proceed?", MsgBoxStyle.OkCancel + MsgBoxStyle.Exclamation) = 1 Then
                Timer1.Enabled = False

                GDevClose()

                Label15.Text = ""
                Command2.Text = "&Start monitor"
            Else
                bRet = False
            End If
        End If

        Termination = bRet

    End Function

    '/////////////////////////////////////////////////////////////////////////////
    '// GDev_OpenMapping Wrapper
    Private Function GDevOpen() As Boolean
        If (IntPtr.Size = 8) Then
            lMapPointer64 = GDev_OpenMapping64(lMapFile, SWNO_SOFTGOT)
        Else
            lMapPointer = GDev_OpenMapping(lMapFile, SWNO_SOFTGOT)
        End If
        GDevOpen = IsGDevOpen()
    End Function

    Private Function IsGDevOpen() As Boolean
        If (IntPtr.Size = 8) Then
            IsGDevOpen = (lMapPointer64 <> 0)
        Else
            IsGDevOpen = (lMapPointer <> 0)
        End If
    End Function

    '/////////////////////////////////////////////////////////////////////////////
    '// GDev_Read Wrapper
    Private Function GDevRead(ByVal sDeviceNameID As Short, ByVal lDevNum As Int32, ByRef iDataTable() As Short, lDataSize As Int32) As Boolean

        Dim size As Integer = (System.Runtime.InteropServices.Marshal.SizeOf(iDataTable(0))) * lDataSize
        Dim pnt As IntPtr = System.Runtime.InteropServices.Marshal.AllocHGlobal(size)

        Dim lRet As Integer
        If (IntPtr.Size = 8) Then
            lRet = GDev_Read64(lMapPointer64, sDeviceNameID, lDevNum, pnt, lDataSize)
        Else
            lRet = GDev_Read(lMapPointer, sDeviceNameID, lDevNum, pnt, lDataSize)
        End If

        System.Runtime.InteropServices.Marshal.Copy(pnt, iDataTable, 0, lDataSize)
        System.Runtime.InteropServices.Marshal.FreeHGlobal(pnt)

        GDevRead = lRet
    End Function

    '/////////////////////////////////////////////////////////////////////////////
    '// GDev_Write Wrapper
    Private Function GDevWrite(ByVal sDeviceNameID As Short, ByVal lDevNum As Int32, ByRef iDataTable() As Short, lDataSize As Int32) As Boolean
        Dim size As Integer = (System.Runtime.InteropServices.Marshal.SizeOf(iDataTable(0))) * lDataSize
        Dim pnt As IntPtr = System.Runtime.InteropServices.Marshal.AllocHGlobal(size)
        System.Runtime.InteropServices.Marshal.Copy(iDataTable, 0, pnt, lDataSize)

        Dim lRet As Integer
        If (IntPtr.Size = 8) Then
            lRet = GDev_Write64(lMapPointer64, sDeviceNameID, lDevNum, pnt, lDataSize)
        Else
            lRet = GDev_Write(lMapPointer, sDeviceNameID, lDevNum, pnt, lDataSize)
        End If

        System.Runtime.InteropServices.Marshal.FreeHGlobal(pnt)

        GDevWrite = lRet
    End Function

    '/////////////////////////////////////////////////////////////////////////////
    '// GDev_CloseUnMapping Wrapper
    Private Sub GDevClose()
        If (IntPtr.Size = 8) Then
            Call GDev_CloseUnMapping64(lMapFile, lMapPointer64)
        Else
            Call GDev_CloseUnMapping(lMapFile, lMapPointer)
        End If

        lMapFile = 0
        lMapPointer = 0
        lMapPointer64 = 0

    End Sub

End Class


